#include "common.h"
#include "resource.h"
#include "fileio.h"
#include "timer.h"
#include "keyboard.h"
#include "windraw.h"
#include "prop.h"
#include "dswin.h"
#include "status.h"
#include "joystick.h"
#include "winui.h"
#include "mkcgrom.h"
#include "winx68k.h"
#include "cdrom.h"
#include "cmdline.h"
#include "sstp.h"
#include "../x68k/m68000.h"
#include "../x68k/memory.h"
#include "../x68k/mfp.h"
//#include "../x68k/opm.h"
#include "../x68k/bg.h"
#include "../x68k/adpcm.h"
#include "../x68k/mercury.h"
#include "../x68k/crtc.h"
#include "../x68k/mfp.h"
#include "../x68k/fdc.h"
#include "../x68k/fdd.h"
#include "../x68k/dmac.h"
#include "../x68k/irqh.h"
#include "../x68k/ioc.h"
#include "../x68k/rtc.h"
#include "../x68k/sasi.h"
#include "../x68k/scsi.h"
#include "../x68k/bg.h"
#include "../x68k/palette.h"
#include "../x68k/crtc.h"
#include "../x68k/pia.h"
#include "../x68k/scc.h"
#include "../x68k/midi.h"
#include "../x68k/sram.h"
#include "../x68k/gvram.h"
#include "../x68k/tvram.h"
#include "../x68k/windrv.h"

#include "../fmgen/fmg_wrap.h"

#ifdef WIN68DEBUG
#include "../x68k/d68k.h"
#endif

const BYTE PrgName[]  = "Keropi";
const BYTE PrgTitle[] = "Keropi";

char winx68k_dir[MAX_PATH];
char winx68k_ini[MAX_PATH];

HINSTANCE hInst;
HWND      hWndMain;
HMENU     hMenu;

WORD      VLINE_TOTAL = 567;
DWORD     VLINE = 0;
DWORD     vline = 0;

extern	int	SplashFlag;

BYTE DispFrame = 0;
extern BYTE FrameRate;
DWORD SoundSampleRate;
int CurFrameRate = 1;
int NoWaitMode = 0;

unsigned int hTimerID = 0;
DWORD TimerICount = 0;
extern DWORD timertick;
int traceflag = 0;

static int ClkUsed = 0;
static int FrameSkipCount = 0;
static int FrameSkipQueue = 0;

	char buf[MAX_PATH];

extern int toggle_cheats;
extern int step_frame;

void CheatAddRAM(unsigned char *ramPtr);
int LoadGameCheats(char *name);
void FlushGameCheats(char *name);
void ApplyPeriodicCheats();
	
void ConfigAddCheat(HWND wnd);
void ConfigCheats(HWND hParent);

void DeInitDebug();
extern void Trace_X68();

FILE *fp1;
FILE *fp;
extern BYTE*	MEM;

extern int trace_map;
extern int hook_trace;

extern FILE *fp_hook;
extern FILE *fp_trace;

#define STATES 3
extern unsigned int *rd_mode, *wr_mode, *ppu_mode, *pc_mode;
extern unsigned int *rd_low, *rd_high;
extern unsigned int *wr_low, *wr_high;
extern unsigned int *ppu_low, *ppu_high;
extern unsigned int *pc_low, *pc_high;
extern unsigned int *pc_start;



// -----------------------------------------------------------------------------------
//  BIOS&FONTǂݍ
// -----------------------------------------------------------------------------------
static const BYTE* BIOSFILE[4]    = {"iplrom.dat", "iplromxv.dat", "iplromco.dat", "iplrom30.dat"};
static const BYTE FONTFILE[]    = "cgrom.dat";
static const BYTE FONTFILETMP[] = "cgrom.tmp";

static	BYTE	SCSIIMG[] = {
			0x00, 0xfc, 0x00, 0x14,			// $fc0000 SCSINp̃GgAhX
			0x00, 0xfc, 0x00, 0x16,			// $fc0004 IOCSxN^ݒ̃GgAhX(K"Human"8oCgO)
			0x00, 0x00, 0x00, 0x00,			// $fc0008 ?
			0x48, 0x75, 0x6d, 0x61,			// $fc000c 
			0x6e, 0x36, 0x38, 0x6b,			// $fc0010 ID "Human68k"	(KNGg|Cg̒O)
			0x4e, 0x75,				// $fc0014 "rts"		(NGg|Cg)
			0x23, 0xfc, 0x00, 0xfc, 0x00, 0x2a,	// $fc0016 		(IOCSxN^ݒGg|Cg)
			0x00, 0x00, 0x07, 0xd4,			// $fc001c "move.l #$fc002a, $7d4.l"
			0x74, 0xff,				// $fc0020 "moveq #-1, d2"
			0x4e, 0x75,				// $fc0022 "rts"
//			0x53, 0x43, 0x53, 0x49, 0x49, 0x4e,	// $fc0024 ID "SCSIIN"
// SCSIONɂƁASASI͎IOFFɂȂႤ炵c
// āAID̓}b`Ȃ悤ɂĂc
			0x44, 0x55, 0x4d, 0x4d, 0x59, 0x20,	// $fc0024 ID "DUMMY "
			0x70, 0xff,				// $fc002a "moveq #-1, d0"	(SCSI IOCSR[Gg|Cg)
			0x4e, 0x75,				// $fc002c "rts"
		};



void WinX68k_SCSICheck(void)
{
	int i, scsi = 0;
	DWORD *p;
	for (i=0x30600; i<0x30c00; i+=2) {
		p = (DWORD*)(&IPL[i]);
		if ( *p==0x0000fc00 ) scsi = 1;
	}

	if ( scsi ) {		// SCSIf̂Ƃ
		ZeroMemory(IPL, 0x2000);			// {̂8kb
		memset(&IPL[0x2000], 0xff, 0x1e000);		// c0xff
		memcpy(IPL, SCSIIMG, sizeof(SCSIIMG));		// C`LSCSI BIOS
	} else {			// SASIfIPL̂܂܌
		memcpy(IPL, &IPL[0x20000], 0x20000);
	}
}


short WinX68k_LoadROMs(void)
{
	FILEH fp = NULL;
	int i;
	BYTE tmp;

	for (i=0; (i<4)&&(!fp); i++) {
		fp = File_OpenCurDir((char*)BIOSFILE[i]);
	}

	if (!fp) {
		Error("BIOS ROM C[W܂.");
		return FALSE;
	}

	File_Read(fp, &IPL[0x20000], 0x20000);
	File_Close(fp);

	WinX68k_SCSICheck();					// SCSI IPLȂA$fc0000`SCSI BIOSu

	for (i=0; i<0x40000; i+=2) {
		tmp = IPL[i];
		IPL[i] = IPL[i+1];
		IPL[i+1] = tmp;
	}

	fp = File_OpenCurDir((char*)FONTFILE);
	if ( !fp ) {
		fp = File_OpenCurDir((char*)FONTFILETMP);		// cgrom.tmpH
		if ( !fp ) {							// Ȃ΍
			MessageBox(hWndMain,
				"tHgROMC[W܂.\nWindowstHgVKɍ쐬܂.",
				"ҁ[̃bZ[W", MB_ICONWARNING | MB_OK);
			SSTP_SendMes(SSTPMES_MAKEFONT);
			make_cgromdat(FONT, FALSE, "lr SVbN", "lr ");
			fp = File_CreateCurDir((char*)FONTFILETMP);
			if ( fp ) {
				File_Write(fp, FONT, 0xc0000);
				File_Close(fp);
				return TRUE;
			}
			return TRUE;
		}
	}
	File_Read(fp, FONT, 0xc0000);
	File_Close(fp);

	return TRUE;
}

// -----------------------------------------------------------------------------------
//  肹Ƃ`
// -----------------------------------------------------------------------------------

int WinX68k_Reset(void)
{
	OPM_Reset();

	ZeroMemory(&regs, sizeof(m68k_regs));
	regs.a[7] = regs.isp = (IPL[0x30001]<<24)|(IPL[0x30000]<<16)|(IPL[0x30003]<<8)|IPL[0x30002];
	regs.pc   = (IPL[0x30005]<<24)|(IPL[0x30004]<<16)|(IPL[0x30007]<<8)|IPL[0x30006];
	regs.sr_high = 0x27;
	M68KRESET();

	Memory_Init();
	CRTC_Init();
	DMA_Init();
	MFP_Init();
	FDC_Init();
	FDD_Reset();
	SASI_Init();
	SCSI_Init();
	IOC_Init();
	SCC_Init();
	PIA_Init();
	RTC_Init();
	TVRAM_Init();
	GVRAM_Init();
	BG_Init();
	Pal_Init();
	IRQH_Init();
	MIDI_Init();
	WinDrv_Init();

	m68000_ICount = 0;
	m68000_ICountBk = 0;
	ICount = 0;

	DSound_Stop();
	SRAM_VirusCheck();
	CDROM_Init();
	DSound_Play();

	return TRUE;
}

// -----------------------------------------------------------------------------------
//  
// -----------------------------------------------------------------------------------

short WinX68k_Init(void)
{
	IPL = (BYTE*)malloc(0x40000);
	MEM = (BYTE*)malloc(0xc00000);			// Ƃ肠12Mb
	FONT = (BYTE*)malloc(0xc0000);
	if ( MEM ) ZeroMemory(MEM, 0xc00000);
	if ( (MEM)&&(FONT)&&(IPL) )
		return TRUE;
	else
		return FALSE;
}

// -----------------------------------------------------------------------------------
//  n
// -----------------------------------------------------------------------------------

void WinX68k_Cleanup(void)
{
	if ( IPL  ) free(IPL);
	if ( MEM  ) free(MEM);
	if ( FONT ) free(FONT);
}


#define CLOCK_SLICE 200
// -----------------------------------------------------------------------------------
//  RÂ߂[
// -----------------------------------------------------------------------------------

void WinX68k_Exec(void)
{
	char *test = NULL;
	int clk_total, clkdiv, usedclk, hsync, clk_next, clk_count, clk_line;
	int KeyIntCnt = 0, MouseIntCnt = 0;
	DWORD t_start = timeGetTime(), t_end;

	if ( FrameRate!=7 ) {
		DispFrame = (DispFrame+1)%FrameRate;
	} else {				// Auto Frame Skip
		if ( FrameSkipQueue ) {
			if ( FrameSkipCount>15 ) {
				FrameSkipCount = 0;
				FrameSkipQueue++;
				DispFrame = 0;
			} else {
				FrameSkipCount++;
				FrameSkipQueue--;
				DispFrame = 1;
			}
		} else {
			FrameSkipCount = 0;
			DispFrame = 0;
		}
	}

	vline = 0;
	clk_count = -ICount;
	clk_total = ((CRTC_Regs[0x29]&0x10)?VSYNC_HIGH:VSYNC_NORM);
	if      ( Config.XVIMode==1 ) { clk_total = (clk_total*16)/10; clkdiv = 16; }
	else if ( Config.XVIMode==2 ) { clk_total = (clk_total*24)/10; clkdiv = 24; }
	else                                                   clkdiv = 10;
	ICount += clk_total;
	clk_next  = (clk_total/VLINE_TOTAL);
	hsync = 1;

	do {
		int m, n = (ICount>CLOCK_SLICE)?CLOCK_SLICE:ICount;
		m68000_ICount = m68000_ICountBk = 0;			// 荞ݔOɗ^ĂȂƃ_iCARATj

		if ( hsync ) {
			hsync = 0;
			clk_line = 0;
			MFP_Int(0);
			if ( (vline>=CRTC_VSTART)&&(vline<CRTC_VEND) )
				VLINE = ((vline-CRTC_VSTART)*CRTC_VStep)/2;
			else
				VLINE = -1;
			if ( (!(MFP[MFP_AER]&0x40))&&(vline==CRTC_IntLine) ) MFP_Int(1);
			if ( MFP[MFP_AER]&0x10 ) {
				if ( vline==CRTC_VSTART ) MFP_Int(9);
			} else {
				if ( CRTC_VEND>=VLINE_TOTAL ) {
					if ( (long)vline==(CRTC_VEND-VLINE_TOTAL) ) MFP_Int(9);		// GLTCeBOA[ƂiTOTAL<VENDj
				} else {
					if ( (long)vline==(VLINE_TOTAL-1) ) MFP_Int(9);			// NCW[NC}[̓RłȂƃ_H
				}
			}
		}

#define	MFCHECK(a) ((a)?MF_CHECKED:MF_UNCHECKED)
		CheckMenuItem(hMenu, IDM_TOGGLE_CHEATS, MFCHECK(toggle_cheats));

		if(toggle_cheats)
			ApplyPeriodicCheats();

#ifdef WIN68DEBUG
		//if (traceflag/*&&fdctrace*/)
		if(0)
		{
			FILE *fp;
			static DWORD oldpc;
			int i;
			char buf[200];
			//fp=fopen("_trace68.txt", "a");
			for (i=0; i<HSYNC_CLK; i++)
			{
#if 0
				m68k_disassemble(buf, regs.pc);
//				if (MEM[0xa84c0]) /**test=1; */tracing=1000;
//				if (regs.pc==0x9d2a) tracing=5000;
//				if ((regs.pc>=0x2000)&&((regs.pc<=0x8e0e0))) tracing=50000;
//				if (regs.pc<0x10000) tracing=1;
//				if ( (regs.pc&1) )
//				fp=fopen("_trace68.txt", "a");
//				if ( (regs.pc==0x7176) /*&& (Memory_ReadW(oldpc)==0xff1a)*/ ) tracing=100;
//				if ( (/*((regs.pc>=0x27000) && (regs.pc<=0x29000))||*/((regs.pc>=0x27000) && (regs.pc<=0x29000))) && (oldpc!=regs.pc))
				if (/*fdctrace&&*/(oldpc!=regs.pc))
				{
//					//tracing--;
					fprintf(fp, "D0:%08X D1:%08X D2:%08X D3:%08X D4:%08X D5:%08X D6:%08X D7:%08X CR:%04X\n", regs.d[0], regs.d[1], regs.d[2], regs.d[3], regs.d[4], regs.d[5], regs.d[6], regs.d[7], regs.ccr);
					fprintf(fp, "A0:%08X A1:%08X A2:%08X A3:%08X A4:%08X A5:%08X A6:%08X A7:%08X SR:%04X\n", regs.a[0], regs.a[1], regs.a[2], regs.a[3], regs.a[4], regs.a[5], regs.a[6], regs.a[7], regs.sr_high);
					fprintf(fp, "<%04X> (%08X ->) %08X : %s\n", Memory_ReadW(regs.pc), oldpc, regs.pc, buf);
				}
#endif
				Trace_X68();

				oldpc = regs.pc;
				m68000_ICount = 1;
				M68KRUN();
			}
			//fclose(fp);
			usedclk = clk_line = HSYNC_CLK;
			clk_count = clk_next;
		}
		else
#endif
		{
		m68000_ICount = n;
		M68KRUN();
		m = (n-m68000_ICount-m68000_ICountBk);			// o߃NbN
		ClkUsed += m*10;
		usedclk = ClkUsed/clkdiv;
		clk_line += usedclk;
		ClkUsed -= usedclk*clkdiv;
		ICount -= m;
		clk_count += m;
		m68000_ICount = m68000_ICountBk = 0;
		}

		MFP_Timer(usedclk);
		RTC_Timer(usedclk);
		DMA_Exec(0);
		DMA_Exec(1);
		DMA_Exec(2);

		if ( clk_count>=clk_next ) {
			OPM_RomeoOut(Config.BufferSize*5);
			MIDI_DelayOut((Config.MIDIAutoDelay)?(Config.BufferSize*5):Config.MIDIDelay);
			MFP_TimerA();
			if ( (MFP[MFP_AER]&0x40)&&(vline==CRTC_IntLine) ) MFP_Int(1);
			if ( (!DispFrame)&&(vline>=CRTC_VSTART)&&(vline<CRTC_VEND) ) {
				if ( CRTC_VStep==1 ) {				// HighReso 256doti2xǂ݁j
					if ( vline%2 ) WinDraw_DrawLine();
				} else if ( CRTC_VStep==4 ) {		// LowReso 512dot
					WinDraw_DrawLine();				// 12`iC^[[Xj
					VLINE++;
					WinDraw_DrawLine();
				} else {							// High 512dot / Low 256dot
					WinDraw_DrawLine();
				}
			}

			ADPCM_PreUpdate(clk_line);
			OPM_Timer(clk_line);
			MIDI_Timer(clk_line);
			Mcry_PreUpdate(clk_line);

			KeyIntCnt++;
			if ( KeyIntCnt>(VLINE_TOTAL/4) ) {
				KeyIntCnt = 0;
				Keyboard_Int();
			}
			MouseIntCnt++;
			if ( MouseIntCnt>(VLINE_TOTAL/8) ) {
				MouseIntCnt = 0;
				SCC_IntCheck();
			}
			DSound_Send0(clk_line);			// BufferłƂp

			vline++;
			clk_next  = (clk_total*(vline+1))/VLINE_TOTAL;
			hsync = 1;
		}
	} while ( vline<VLINE_TOTAL );

	if ( CRTC_Mode&2 ) {		// FastClrrbg̒iPITAPATj
		if ( CRTC_FastClr ) {	// FastClr=1  CRTC_Mode&2 Ȃ I
			CRTC_FastClr--;
			if ( !CRTC_FastClr ) CRTC_Mode &= 0xfd;
		} else {				// FastClrJn
			if ( CRTC_Regs[0x29]&0x10 )
				CRTC_FastClr = 1;
			else
				CRTC_FastClr = 2;
			TVRAM_SetAllDirty();
			GVRAM_FastClear();
		}
	}

	Joystick_Update();
	DSound_Send();
	FDD_SetFDInt();
	if ( !DispFrame ) WinDraw_Draw();
	TimerICount += clk_total;

	t_end = timeGetTime();
	if ( (int)(t_end-t_start)>((CRTC_Regs[0x29]&0x10)?14:16) ) {
		FrameSkipQueue += ((t_end-t_start)/((CRTC_Regs[0x29]&0x10)?14:16))+1;
		if ( FrameSkipQueue>100 ) FrameSkipQueue = 100;
	}
}


// --------------------------------------------------------------------------
//   񑩂̃C
// --------------------------------------------------------------------------

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPreInst,
				LPSTR lpszCmdLine, int nCmdShow)
{
	WNDCLASS winx68k;
	MSG msg;
	HIMC hIMC;
	HWND hwnd;
	DWORD StartTime;
	LPTSTR filepart;
	char buf[MAX_PATH];

	if ((hwnd = FindWindow(PrgName, NULL)) != NULL) {
		ShowWindow(hwnd, SW_RESTORE);
		SetForegroundWindow(hwnd);
		SSTP_Init();
		SSTP_SendMes(SSTPMES_DUALBOOT);
		SSTP_Cleanup();
		return(FALSE);
	}

	hInst = hInstance;

	GetModuleFileName(NULL, buf, MAX_PATH);
	GetFullPathName(buf, MAX_PATH, winx68k_dir, &filepart);
	*filepart = 0;
	strcpy(winx68k_ini, winx68k_dir);
	strcat(winx68k_ini, "winx68k.ini");

	if (!hPreInst) {
		winx68k.style = CS_BYTEALIGNCLIENT | CS_HREDRAW | CS_VREDRAW;
		winx68k.lpfnWndProc = WndProc;
		winx68k.cbClsExtra = 0;
		winx68k.cbWndExtra = 0;
		winx68k.hInstance = hInstance;
		winx68k.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_MAIN_ICON));
		winx68k.hCursor = LoadCursor(NULL, IDC_ARROW);
		winx68k.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
		winx68k.lpszMenuName = MAKEINTRESOURCE(IDR_MENU);
		winx68k.lpszClassName = PrgName;
		if (!RegisterClass(&winx68k)) {
			return(FALSE);
		}
	}

	hWndMain = CreateWindowEx(WS_EX_ACCEPTFILES,
			PrgName, PrgTitle,
			WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION |
			WS_MINIMIZEBOX,
			CW_USEDEFAULT, CW_USEDEFAULT,
			SCREEN_WIDTH, SCREEN_HEIGHT,
			NULL, NULL, hInstance, NULL);

	hMenu = GetMenu(hWndMain);
	hIMC = ImmAssociateContext(hWndMain, 0);

	LoadConfig();

	SSTP_Init();

	CheckCmdLine(lpszCmdLine);

	SplashFlag = 20;
	SoundSampleRate = Config.SampleRate;

	StatBar_Show(Config.WindowFDDStat);
	WinDraw_ChangeSize();
	WinDraw_ChangeMode(FALSE);

	//StatBar_Show(FALSE);

	ShowWindow(hWndMain, nCmdShow);
	UpdateWindow(hWndMain);

	WinUI_Init();
	WinDraw_StartupScreen();

	if (!WinDraw_Init()) {
		WinDraw_Cleanup();
		Error("@DirectDraw̏Ɏs܂. \n\n@ʃ[hu16rbgvɂȂĂ邩ǂ, , \nʃTCYu800x600vȏɐݒ肳Ă邩ǂ\nmFĂ.");
		return FALSE;
	}

	if (!WinX68k_Init())
	{
		WinX68k_Cleanup();
		WinDraw_Cleanup();
		Error("܂.");
		return FALSE;
	}
	if (!WinX68k_LoadROMs())
	{
		WinX68k_Cleanup();
		WinDraw_Cleanup();
		return FALSE;
	}

	timeBeginPeriod(1);
	StartTime = timeGetTime();

	if ( SoundSampleRate ) {
		ADPCM_Init(SoundSampleRate);
		OPM_Init(4000000/*3579545*/, SoundSampleRate);
		Mcry_Init(SoundSampleRate, winx68k_dir);
	} else {
		ADPCM_Init(100);
		OPM_Init(4000000/*3579545*/, 100);
		Mcry_Init(100, winx68k_dir);
	}

	Joystick_Init();
	SRAM_Init();
	WinX68k_Reset();
	Timer_Init();

	MIDI_Init();
	MIDI_SetMimpiMap(Config.ToneMapFile);		// Fݒt@Cgpf
	MIDI_EnableMimpiDef(Config.ToneMap);

	if ( !DSound_Init(Config.SampleRate, Config.BufferSize) )
		if ( Config.DSAlert ) Error("DirectSound̏Ɏs܂B\nTEhŌp܂B");

	ADPCM_SetVolume((BYTE)Config.PCM_VOL);
	OPM_SetVolume((BYTE)Config.OPM_VOL);
	Mcry_SetVolume((BYTE)Config.MCR_VOL);
	DSound_Play();

	SetCmdLineFD();			// R}hCFD}wĂꍇAœ

	hTimerID = SetTimer(hWndMain, 1, 500, 0);
	srand(timeGetTime());

///////////////////////////////////////////////////
///////////////////////////////////////////////////

	sprintf( buf, "%s%s", winx68k_dir, "cheats.txt" );

	
	//gui_hInstance = hInstance;
	CheatAddRAM(MEM);
	LoadGameCheats( buf );


	sprintf( buf, "%s%s", winx68k_dir, "hook_log.txt" );

	fp1 = fopen( buf, "r" );
	if( fp1 )
	{
		rd_mode = malloc( 4*STATES );
		wr_mode = malloc( 4*STATES );
		pc_mode = malloc( 4*STATES );
		ppu_mode = malloc( 4*STATES );

		rd_low = malloc( 4*STATES );
		wr_low = malloc( 4*STATES );
		pc_low = malloc( 4*STATES );
		ppu_low = malloc( 4*STATES );

		rd_high = malloc( 4*STATES );
		wr_high = malloc( 4*STATES );
		pc_high = malloc( 4*STATES );
		ppu_high = malloc( 4*STATES );

		pc_start = malloc( 4*STATES );

		fscanf(fp1,"hook_pc1 %x %x %x\n",&pc_mode[0],&pc_low[0],&pc_high[0]);
    fscanf(fp1,"hook_pc2 %x %x %x\n",&pc_mode[1],&pc_low[1],&pc_high[1]);
    fscanf(fp1,"hook_pc3 %x %x %x\n",&pc_mode[2],&pc_low[2],&pc_high[2]);

		fscanf(fp1,"hook_rd1 %x %x %x\n",&rd_mode[0],&rd_low[0],&rd_high[0]);
    fscanf(fp1,"hook_rd2 %x %x %x\n",&rd_mode[1],&rd_low[1],&rd_high[1]);
    fscanf(fp1,"hook_rd3 %x %x %x\n",&rd_mode[2],&rd_low[2],&rd_high[2]);

		fscanf(fp1,"hook_wr1 %x %x %x\n",&wr_mode[0],&wr_low[0],&wr_high[0]);
    fscanf(fp1,"hook_wr2 %x %x %x\n",&wr_mode[1],&wr_low[1],&wr_high[1]);
    fscanf(fp1,"hook_wr3 %x %x %x\n",&wr_mode[2],&wr_low[2],&wr_high[2]);

		fscanf(fp1,"hook_ppu1 %x %x %x\n",&ppu_mode[0],&ppu_low[0],&ppu_high[0]);
    fscanf(fp1,"hook_ppu2 %x %x %x\n",&ppu_mode[1],&ppu_low[1],&ppu_high[1]);
    fscanf(fp1,"hook_ppu3 %x %x %x\n",&ppu_mode[2],&ppu_low[2],&ppu_high[2]);

		pc_start[0] = 0;
		pc_start[1] = 0;
		pc_start[2] = 0;

		fclose( fp1 );
	}
///////////////////////////////////////////////////
///////////////////////////////////////////////////
	
	while (1) {
		if ( PeekMessage(&msg, 0, 0, 0, PM_NOREMOVE) ) {
			if ( !GetMessage(&msg, NULL, 0, 0) ) break;
			DispatchMessage(&msg);
		} else {
//			OPM_RomeoOut(Config.BufferSize*5);
			if ( ((NoWaitMode)||(Timer_GetCount())) && (step_frame != 2) ) {
				
				WinX68k_Exec();
				if( step_frame==1 )
					step_frame=2;
				
				if ( SplashFlag ) {
					SplashFlag--;
					if ( !SplashFlag ) WinDraw_HideSplash();
				}
			} else {
				Sleep(1);
			}
		}
	}

	if ( hTimerID ) KillTimer(hWndMain, hTimerID);
	timeEndPeriod(1);
	ImmAssociateContext(hWndMain, hIMC);

	Memory_WriteB(0xe8e00d, 0x31);														// SRAM݋
	Memory_WriteD(0xed0040, Memory_ReadD(0xed0040)+1+(timeGetTime()-StartTime)/60000);	// ώZғ(min.)i[NX^ŎgĂ̂ŁAĂƁ[ɑĂj
	Memory_WriteD(0xed0044, Memory_ReadD(0xed0044)+1);									// ώZN

	OPM_Cleanup();
	Mcry_Cleanup();

	SRAM_Cleanup();
	FDD_Cleanup();
	CDROM_Cleanup();
	MIDI_Cleanup();
	Joystick_Cleanup();
	DSound_Cleanup();
	WinX68k_Cleanup();
	WinDraw_Cleanup();
	WinDraw_CleanupScreen();
	SSTP_Cleanup();

	SaveConfig();

	{
		char buf[MAX_PATH];
		sprintf( buf, "%s%s", winx68k_dir, "cheats.txt" );

		DeInitDebug();
		FlushGameCheats( buf );
	}

	return msg.wParam;
}
